/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.sso;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.javascript.JSObject;
import org.apache.soap.util.net.HTTPUtils;

public class CookieManager {
    private static final String SMIDENTITY = "SMIDENTITY";
    private static final String SMSESSION = "SMSESSION";
    private static final String JSESSIONID = "JSESSIONID";
    private static Logger logger = Logger.getLogger("filenet.pe.sso");
    private static final String m_className = "CookieManager";
    private Map store = new HashMap();
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE_VALUE_DELIMITER = ";";
    private static final String PATH = "path";
    private static final String EXPIRES = "expires";
    private static final String DATE_FORMAT = "EEE, dd-MMM-yyyy hh:mm:ss z";
    private static final String SET_COOKIE_SEPARATOR = "; ";
    private static final String COOKIE = "Cookie";
    private static final char NAME_VALUE_SEPARATOR = '=';
    private static final char DOT = '.';
    private DateFormat dateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    protected static Logger HTTPLogger = Logger.getLogger("filenet.pe.HTTP");
    protected static boolean logHTTP = HTTPLogger.isLoggable(Level.FINEST);

    private void createCookiefromSetCookieHeader(Map domainStore, String setCookieValue) {
        String value;
        String name;
        int equalSignIndex;
        String token;
        String m_method = "createCookieFromSetCookieHeader";
        HashMap<String, String> cookie = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(setCookieValue, COOKIE_VALUE_DELIMITER);
        if (logger.isFinest()) {
            logger.finest(m_className, "createCookieFromSetCookieHeader", "IN:" + setCookieValue);
        }
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            equalSignIndex = token.indexOf(61);
            if (equalSignIndex == -1) {
                return;
            }
            name = token.substring(0, equalSignIndex);
            if (name == null || name.trim().length() == 0) {
                return;
            }
            name = name.trim();
            value = token.substring(equalSignIndex + 1, token.length());
            domainStore.put(name, cookie);
            cookie.put(name, value);
            if (logger.isFinest()) {
                logger.finest(m_className, "createCookieFromSetCookieHeader", "SET1:" + name + "=" + value);
            }
        }
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            equalSignIndex = token.indexOf(61);
            if (equalSignIndex == -1 || (name = token.substring(0, equalSignIndex).toLowerCase()) == null || name.trim().length() == 0) continue;
            name = name.trim();
            value = token.substring(equalSignIndex + 1, token.length());
            cookie.put(name, value);
            if (!logger.isFinest()) continue;
            logger.finest(m_className, "createCookieFromSetCookieHeader", "SET2:" + name + "=" + value);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(m_className, "createCookieFromSetCookieHeader", ((Object)cookie).toString());
        }
    }

    public void storeCookies(URLConnection conn) throws IOException {
        String m_method = "storeCookies";
        if (logger.isFinest()) {
            logger.entering(m_className, "storeCookies");
        }
        Map domainStore = this.getDomainStore(conn.getURL());
        String headerName = null;
        int i = 1;
        while ((headerName = conn.getHeaderFieldKey(i)) != null) {
            if (headerName.equalsIgnoreCase(SET_COOKIE)) {
                this.createCookiefromSetCookieHeader(domainStore, conn.getHeaderField(i));
            }
            ++i;
        }
        if (logger.isFinest()) {
            logger.exiting(m_className, "storeCookies");
        }
    }

    private Map getDomainStore(URL url) {
        HashMap domainStore;
        String domain = this.getDomainFromHost(url.getHost());
        if (this.store.containsKey(domain)) {
            domainStore = (HashMap)this.store.get(domain);
        } else {
            if (logger.isFinest()) {
                logger.finest(m_className, "getDomainStore", "URL:" + url.toString() + "Creating new domain store..");
            }
            domainStore = new HashMap();
            this.store.put(domain, domainStore);
        }
        return domainStore;
    }

    public void storeCookiesFromSetCookieHeaders(URL url, Vector setCookieHeaders) {
        Map domainStore = this.getDomainStore(url);
        Iterator valIter = setCookieHeaders.iterator();
        while (valIter.hasNext()) {
            this.createCookiefromSetCookieHeader(domainStore, (String)valIter.next());
        }
    }

    public static String mergeCookies(URL url, String oldCookie, String[] newCookies) {
        String res;
        String m_method = "mergeCookies:" + url;
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "oldCookie=" + oldCookie + ", newCookies=" + Logger.asString(newCookies));
        }
        try {
            CookieManager cookieManager = new CookieManager();
            cookieManager.storeCookies(url, oldCookie.split(COOKIE_VALUE_DELIMITER));
            cookieManager.mergeMyCookies(url, newCookies);
            res = cookieManager.getCookie(url);
        }
        catch (Exception e) {
            res = oldCookie;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Returning:" + res);
        }
        return res;
    }

    protected void mergeMyCookies(URL url, String[] newCookies) {
        int nNewCookies;
        int n = nNewCookies = newCookies == null ? 0 : newCookies.length;
        if (nNewCookies == 0) {
            return;
        }
        Map domainStore = this.getDomainStore(url);
        for (int i = 0; i < nNewCookies; ++i) {
            this.createCookiefromSetCookieHeader(domainStore, newCookies[i].trim());
        }
    }

    private void storeCookies(URL url, String[] cookies) {
        int nCookies;
        if (url == null) {
            return;
        }
        Map domainStore = this.getDomainStore(url);
        int n = nCookies = cookies == null ? 0 : cookies.length;
        if (nCookies == 0) {
            return;
        }
        for (int i = 0; i < nCookies; ++i) {
            this.createCookiefromSetCookieHeader(domainStore, cookies[i]);
        }
    }

    public String getCookie(URL url) {
        String domain = this.getDomainFromHost(url.getHost());
        String path = url.getPath();
        Map domainStore = (Map)this.store.get(domain);
        if (domainStore == null) {
            return null;
        }
        StringBuffer cookieStringBuffer = new StringBuffer();
        Iterator cookieNames = domainStore.keySet().iterator();
        while (cookieNames.hasNext()) {
            String cookieName = (String)cookieNames.next();
            Map cookie = (Map)domainStore.get(cookieName);
            if (!this.comparePaths((String)cookie.get(PATH), path) || !this.isNotExpired((String)cookie.get(EXPIRES))) continue;
            cookieStringBuffer.append(cookieName);
            cookieStringBuffer.append("=");
            cookieStringBuffer.append((String)cookie.get(cookieName));
            if (!cookieNames.hasNext()) continue;
            cookieStringBuffer.append(SET_COOKIE_SEPARATOR);
        }
        String myCookie = cookieStringBuffer.toString();
        return myCookie;
    }

    public void setCookies(URLConnection conn) throws IOException {
        String m_method = "setCookies(URLConnection)";
        try {
            String myCookie = this.getCookie(conn.getURL());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(m_className, "setCookies(URLConnection)", "Setting Cookie " + myCookie);
            }
            conn.setRequestProperty(COOKIE, myCookie);
        }
        catch (IllegalStateException ise) {
            IOException ioe = new IOException("Illegal State! Cookies cannot be set on a URLConnection that is already connected. Only call setCookies(java.net.URLConnection) AFTER calling java.net.URLConnection.connect().");
            throw ioe;
        }
    }

    private String getDomainFromHost(String host) {
        String res = host;
        if (host.indexOf(46) != host.lastIndexOf(46)) {
            res = host.substring(host.indexOf(46) + 1);
        }
        res = res.trim();
        if (logger.isFinest()) {
            logger.finest(m_className, "getDomainFromHost", host + "," + res);
        }
        return res;
    }

    private boolean isNotExpired(String cookieExpires) {
        if (cookieExpires == null) {
            return true;
        }
        Date now = new Date();
        try {
            return now.compareTo(this.dateFormat.parse(cookieExpires)) <= 0;
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            return false;
        }
    }

    private boolean comparePaths(String cookiePath, String targetPath) {
        if (cookiePath == null) {
            return true;
        }
        if (cookiePath.equals("/")) {
            return true;
        }
        return targetPath.regionMatches(0, cookiePath, 0, cookiePath.length());
    }

    public String toString() {
        return this.store.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void SM_KLUDGE(String s, CookieManager TheCookieManager, int count, StringBuffer resBuf) throws Exception {
        String m_method = "SM_KLUDGE:";
        if (s == null) {
            return;
        }
        logger.entering(m_className, m_method);
        try {
            URL u = new URL(s);
            m_method = m_method + u.getPath();
            StringBuffer buf = new StringBuffer();
            HttpURLConnection uc = (HttpURLConnection)u.openConnection();
            uc.setInstanceFollowRedirects(false);
            TheCookieManager.setCookies(uc);
            int code = uc.getResponseCode();
            String location = null;
            String response = uc.getResponseMessage();
            buf.append("HTTP/1.x ").append(code).append(" ").append(response);
            Vector<String> setCookieHeaders = new Vector<String>();
            int j = 1;
            while (true) {
                String header = uc.getHeaderField(j);
                String key = uc.getHeaderFieldKey(j);
                if (header == null || key == null) break;
                if (code == 302 && key.equalsIgnoreCase("location")) {
                    location = header;
                }
                if (key.equalsIgnoreCase(SET_COOKIE)) {
                    setCookieHeaders.add(header);
                }
                buf.append(key).append(": ").append(header).append("\n");
                ++j;
            }
            TheCookieManager.storeCookiesFromSetCookieHeaders(u, setCookieHeaders);
            if (code == 302) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(m_className, m_method, "====== Redirecting to " + location);
                }
                if (++count > 20) {
                    logger.severe(m_className, m_method, "Too many redirections!!!");
                    throw new VWException("filenet.pe.sso.CookieManager.TooManyRedirectionsPossibleTimeout", "Too many redirections!! (>20). Timeout detected.  Please close the applets and retry the link.");
                }
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "FOLLOWING REDIRECTION..." + count);
                }
                CookieManager.SM_KLUDGE(location, TheCookieManager, count, resBuf);
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "DONE FOLLOWING REDIRECTION..." + count);
                }
            } else {
                int c;
                BufferedInputStream in = new BufferedInputStream(uc.getInputStream());
                InputStreamReader r = new InputStreamReader(in);
                while ((c = ((Reader)r).read()) != -1) {
                    buf.append((char)c);
                    if (resBuf == null) continue;
                    resBuf.append((char)c);
                }
                String contents = buf.toString();
                if (contents.indexOf("FILENET P8 BPM RESPONDED OK") != -1) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(m_className, m_method, "OKOKOKOKOK\n" + contents);
                    }
                } else {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(m_className, m_method, "======== CANNOT REACH IT!!! ---\nContents=" + contents);
                    }
                    throw new VWException("filenet.pe.sso.CookieManager.UnrecognizableContents", "Cannot reach the service.  Unrecognizable Contents: {0}", contents);
                }
            }
            Object var17_18 = null;
            logger.exiting(m_className, m_method);
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    public static String checkSMCookies(String cookie, URL sendTo, StringBuffer resBuf) throws VWException {
        if (cookie == null) {
            return cookie;
        }
        String m_method = "checkSMCookies:" + sendTo + "," + cookie;
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(m_className, m_method, "------------------------");
            }
            CookieManager TheCookieManager = new CookieManager();
            TheCookieManager.storeCookies(sendTo, cookie.split(COOKIE_VALUE_DELIMITER));
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Calling SM_KLUDGE");
            }
            CookieManager.SM_KLUDGE(sendTo.toString(), TheCookieManager, 0, resBuf);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Done Calling SM_KLUDGE");
            }
            cookie = TheCookieManager.getCookie(sendTo);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(m_className, m_method, "-----------RETURNING COOKIE=" + cookie);
            }
            return cookie;
        }
        catch (Throwable t) {
            logger.throwing(m_className, m_method, t);
            throw new VWException(t);
        }
    }

    private static String getDocumentCookies(Applet m_applet) {
        String m_method = "getDocumentCookies";
        try {
            Object[] params = new String[]{};
            String jsFunction = "getDocumentCookies";
            JSObject window = JSObject.getWindow((Applet)m_applet);
            Object retVal = window.call(jsFunction, params);
            if (retVal instanceof String) {
                return (String)retVal;
            }
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getDocumentCookies", t);
        }
        return null;
    }

    private static String getJavaScriptCookie(Applet m_applet, String cookieName) {
        String m_method = "getCookie";
        try {
            Object[] params = new String[]{cookieName};
            String jsFunction = "getCookie";
            JSObject window = JSObject.getWindow((Applet)m_applet);
            Object retVal = window.call(jsFunction, params);
            if (retVal instanceof String) {
                return (String)retVal;
            }
        }
        catch (Throwable t) {
            logger.throwing(m_className, "getCookie", t);
        }
        return null;
    }

    public static String checkSMCookiesForApplet(Applet applet, String requestInfo) throws Throwable {
        String m_method = "checkSMCookiesForApplet";
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(m_className, "checkSMCookiesForApplet", "------------------------");
            }
            URL vwSoapRouterURL = new URL(applet.getParameter("baseURL") + "vwsoaprouter");
            CookieManager TheCookieManager = new CookieManager();
            String[] cookies = new String[]{};
            String documentCookies = CookieManager.getDocumentCookies(applet);
            if (documentCookies != null && documentCookies.length() > 0) {
                documentCookies = documentCookies.replace(',', ';');
                cookies = documentCookies.split(COOKIE_VALUE_DELIMITER);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(m_className, "checkSMCookiesForApplet", "Retrieved cookies from browser = " + Logger.asString(cookies));
                }
            } else {
                return null;
            }
            TheCookieManager.storeCookies(vwSoapRouterURL, cookies);
            if (logger.isFinest()) {
                logger.finest(m_className, "checkSMCookiesForApplet", "Calling SM_KLUDGE");
            }
            CookieManager.SM_KLUDGE(vwSoapRouterURL.toString(), TheCookieManager, 0, new StringBuffer());
            if (logger.isFinest()) {
                logger.finest(m_className, "checkSMCookiesForApplet", "Done Calling SM_KLUDGE");
            }
            String myCookie = TheCookieManager.getCookie(vwSoapRouterURL);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(m_className, "checkSMCookiesForApplet", "----------RETURNING COOKIE=" + myCookie);
            }
            return myCookie;
        }
        catch (Throwable t) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(m_className, "checkSMCookiesForApplet", "IGNORE exception:" + t.getLocalizedMessage());
                logger.throwing(m_className, "checkSMCookiesForApplet", t);
            }
            return null;
        }
    }

    public static void HTTPTracing(String className, String methodName, String s) {
        if (logHTTP) {
            HTTPLogger.finest(className, methodName, s);
        }
    }

    public static void checkSMCookiesForRequestResponseHeaders(URL url, Hashtable reqHeaders, Hashtable resHeaders, String statusCodeString) {
        String oldCookie = HTTPUtils.getHeaderValue((Hashtable)reqHeaders, (String)COOKIE);
        String newCookie = HTTPUtils.getHeaderValue((Hashtable)resHeaders, (String)SET_COOKIE);
        String newerCookie = oldCookie;
        if (newCookie != null) {
            newerCookie = CookieManager.mergeCookies(url, oldCookie, newCookie.split(","));
        }
        if (newerCookie != oldCookie) {
            HTTPUtils.removeHeader((Hashtable)reqHeaders, (String)COOKIE);
            reqHeaders.put(COOKIE, newerCookie);
        }
        resHeaders.put(COOKIE, newerCookie);
        HTTPUtils.removeHeader((Hashtable)resHeaders, (String)SET_COOKIE);
        if (logHTTP) {
            StringBuffer logBuf = new StringBuffer();
            logBuf.append("RESPONSE Code=").append(statusCodeString).append("\n");
            Enumeration keyNames = resHeaders.keys();
            while (keyNames.hasMoreElements()) {
                String key = (String)keyNames.nextElement();
                String value = (String)resHeaders.get(key);
                logBuf.append(key).append(":").append(value).append("\n");
            }
            HTTPLogger.finest("HTTP", "post", logBuf.toString());
        }
    }

    public static void main(String[] args) {
        try {
            String oldCookie = "SMSESSION=S57h3EYSplZmdOaZXchzgEph2G9jumvWPHIaxTMQWAn0Kslxp7dPkU55S5px9tQ7PFUJUbJ6ynFAjOhFL6ClziDW4rMi1Vv5iJRTek8PH4+loVbugLoOuAo0baG7W0E3tlCsYdwrMAtAMwwGFfmKc7oEiPlaMt3XaTRbBI1w3XL9L8XGqyyttID/Z3HjUMZ3cq5876j0DHnIof07Z4T1Yyc/MlxRcfpHnjUaa7nKsGD3G9rRrCcS+Wl2yGqgtK4Qb44w4tiyVUu83D1u/lDgqbnNp0iB4pF/Lo5NzCqeGdmlj/nR7roD2NXh6B0REz9wDmwyrh3C52DRFGVNuYcjTwlrz7AG0sOh0xxPybXs4b0Ls6uegjIuiFu0qqlQv7ciuIQ/B7HUuSymRVgY/IzSPHZnR/13VeGLqOV4WJAKj7emCh9h8qEfahEJ+8A88lsr0cKBxwOBQhVTihV0vPAKLseElrRae5BXjLZKwvC4xeewM8/osY6cq0E9ipUxkpTXF2hggZo3Z2epmFw2X5Jvng0IaYDC32G98enSa3fVfSbKIDKuU0DioFYXaqZeZ3Khb60ycBJuy/G4CuZjytjrNQ4JpFukFqiPBgevCzO2X0CEkikvNPNriV5Ke7bRshbYqHeGRKRM1HWdNpu5l9+rNZ4rsX5DL1Pu4B05G5j3S8JSNU2ri0/MwXuBQsBEFZSPNaicelmelCLWphUEkXn9CjyLHCkOCP1p1ccWQO7gPril5LOSTWFUY94iDuH+0YCgd6lrQB+0M0SZfQHoDe++2eQQ3cLfXrWJQFUUCJ0hzsDGqLjqMWqWDReSSG1clpgWVIvOi4S9NQZi3C/ubDFFKV2l47QOWrQ8DphZyqqdZM6ZmtypUPOVeUfq+eIO/FEC98g7AcqYoIs8ieHX24vclZ/uQ2fQkmPHS08w4g5DmDpO0pjmMKnpnCoSF7UTwTr5qG005xwFcP8JE6GpQpjonydHrMXh0zwsqs1YUI/y6QfjqyFrSBYb/1LA/jDYJh9C2eo+SzBc3ANEHoh3U0tBLopPaXrOJBAnE/OeXZ82vKAXA5gm9rVSZg/0feTD+CYYJ8a+3UiywRqEfT+siRyYnk6rAr5H1CZ+gNRvesd7+6UkaWUojNIlL58tekHPdsrYX0vSLWWnS5I25r66LRw/RHTlO42+U3aW; JSESSIONID=GstyB2GfBrWVZKnWy79mbnN6bQgLP3TZWfQwQ7rMM5CDNNBvQbQ7!1310018632; SMIDENTITY=sLI/1AZNULGwD9CrJ+qoDaZN94WjCGXGRo/4idSswtK6mlFIdcKwPIp0VL5I1bRNZvQoCBdCO+zRLD1oydPjNqAMKlvDKIUosmEt1dE03XppRg62EGWlYlq8C/eBSiT4RVljlkKGok/NHXtXvYHNRmHPx6SQIMIJwCV64OuKVbHT5WL3K7qnRD2mcJLW+wJ9buc6bpmU9XKbMFqWYw3PSqsuJD64hBbX++krZ5tejoeCpjItRxMT29LdoqBIGmnhrTmQ0/Mgyl3pRtdkdUeZ75h+k9Edg/hiuIVgBSXsJ1ou1lP3TfYGri5Ede1Aszx+3vFMaCB4nGk5JEwrBo4MO97Sb4N1eoRA3+KVDhR+/8UrnWVUy9EhL5yQnQ9bSHp2m+dzYEvJqc5JX7dfw5zU+aP6dbF9+fu8hCOgaRtojvT6FAD/eDmzNKVymaN5cmlODj8Cbv4UkAkjHNQV5eXUQvazLTRKKApZ7ToTemYZtXQHnR6bPUxIVp1ooAO9IpanhqmLYHrU6ft/4/K+vOh7FaLSZhFQlP4LMyS3TQHPmFBGH1R3GSpWToKMj1OHf1X71go0wkCwWk2V3Ga/Zn46i0HzjYoaBun+5yD44ZeotSog12jWa7fdn48Gf6TfRFywkmVnHrO0p4siIDRpEAzcVRBhU7KcLiJDKXx8TKOPOgVQvWk4mx+XMzkHZiLvmNYAmt6EbDz1aQT6RRl5dhHxYSEsyeZLqtYwuEsxCw/jAT6DhbpLX9DGfvp+vOrpmS5O+X2kKzyG14jDKP+sa5z1H0DKBGcczGrO9tCocB09M1Lww1lNAUk66JCqQtrdJY7O";
            String newCookie = "SMSESSION=DodLEtKCiGGnshcNEUmuY0rX4U2I31yZOIto26msRYQucaTMpZEaae3ICGyj5ZNBYSz0OF/9QbrHjarOCoGVzZNs8cP/Fn7L854iBxR+URRFZTI7j3l6h0tbXm9kYJs5/sSeOvsaLkARkDm5l/KrUx3sO6fqwUSMwgtcgOLhRISFQsk7wvyjEswBtUeN0Wlco4FG9LPPafgQHlfsOczs6WzbvfK++MOvQiFq1e5OpY8kiB6pU99Fd6hC8Skj6aFyaSjqelqPY1LbpVyxnyVXEp4y/dMFpFxwOxaWrSAfruckm5hQ10emWb7WywZos5XNF4xfda+P4T+AZzHmvPytvsAhwIaFi0vpgFErbGv0EiBa/MabdZZs+VLkvihPQG1D2U1YSylK4Vd5URCUAPqzgi+pIkVzCCr44giTDbf+5DJr7WY6ICNVopTzRjSFJKPisK7FTj3+go/0X2cYbhSyW29mMz3RCzspuUeX/on+NoG8lqBZvi1gOfcx7frKRTyrpkH9T3le2PPbgS5XNjcBFvg6QD53F7lBn2dGcxk1bZN11gNRSggdgupYK3P+8ObHqrzf3LQ+rW2KoYScKvsMj+N1oEQpIAai85jelrTM1BhmlIqAqoryzY1E8lipeevqX+unJasrOnB861352FR/kz652QKYAyLlMkQ2X536VlWeEcVLW4hbnWUtFnG93Ey1qRJWP0ojOdlEyah/FHmupzJmXnqAo6HmB9iNiov/ceB2ak55vm6oCn3kCfk3pnDZnhVTAN9126cDWjFY4cHPVtwuxWG/McVmMWEzzLqFydVRrqIN+Uadu6FnC9tYFajK2/jo+z2WS6oC5aHUY3kSsuztt1tgwT7IeLYFi5GfbP5WCeANgYDF+rgzKV7W2ykk/yEYsGvBdnhx2WUEN14smpfaw1VxdzIy5ZJ29op8/+7xNZkff/3UH5DsjArwbYoeQ23vhFcE086LSFydJyw0FGNxi8Iub/edRTrlZOWBc3ErOdUHRdhAfcbmngPl94PLDbu3JpYtuc3pJV8Ra7FOml1AmB/0FEZHVzSpUUIvdLo7f3xtR10HedvafIFHRTFFg0OxZxGAbgzdBv5T6V8QYrhfIHnC96OcgSLSn01ucSLYF3pDaH7up2ZxZCGVnlyOqt2k4nah9Ct0020n8xPw9z1PcW83q7QE; path=/; domain=.w2k3dom1.eng.filenet.com";
            String newerCookie = oldCookie;
            if (newCookie != null) {
                newerCookie = CookieManager.mergeCookies(new URL("http://hq-intgweb.w2k3dom1.eng.filenet.com:7001/Workplace/vwsoaprouter"), oldCookie, newCookie.split(","));
            }
            System.out.println("newerCookie=" + newerCookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

